import sys
from random import choice

from PyQt6.QtWidgets import QApplication, QMainWindow, QPushButton

window_titles = [  # <1>
    "My App",
    "Still My App",
    "What on earth",
    "This is surprising",
    "Something went wrong",
]


class MainWindow(QMainWindow):
    def __init__(self):
        super().__init__()

        self.n_times_clicked = 0

        self.setWindowTitle("My App")

        self.button = QPushButton("Press Me!")
        self.button.clicked.connect(self.the_button_was_clicked)

        self.windowTitleChanged.connect(
            self.the_window_title_changed
        )  # <2>

        # Set the central widget of the Window.
        self.setCentralWidget(self.button)

    def the_button_was_clicked(self):
        print("Clicked.")
        new_window_title = choice(window_titles)
        print(f"Setting title: {new_window_title}")
        self.setWindowTitle(new_window_title)  # <3>

    def the_window_title_changed(self, window_title):
        print(f"Window title changed: {window_title}")  # <4>

        if window_title == "Something went wrong":
            self.button.setDisabled(True)


app = QApplication(sys.argv)

window = MainWindow()
window.show()

app.exec()
