import sys

from PyQt6.QtWidgets import QApplication, QMainWindow


class MainWindow(QMainWindow):
    def __init__(self):
        super().__init__()

        # SIGNAL: The connected function will be called whenever the
        # window title is changed. The new title will be passed to
        # the function.
        self.windowTitleChanged.connect(self.on_window_title_changed)

        # SIGNAL: The connected function will be called whenever the
        # window title is changed. The new title is discarded in the
        # lambda and the function is called without parameters.
        self.windowTitleChanged.connect(
            lambda x: self.my_custom_fn()
        )

        # SIGNAL: The connected function will be called whenever the
        # window title is changed. The new title is passed to the
        # function and replaces the default parameter
        self.windowTitleChanged.connect(
            lambda x: self.my_custom_fn(x)
        )

        # SIGNAL: The connected function will be called whenever the
        # window title is changed. The new title is passed to the
        # function and replaces the default parameter. Extra data is
        # passed from within the lambda.
        self.windowTitleChanged.connect(
            lambda x: self.my_custom_fn(x, 25)
        )

        # This sets the window title which will trigger all the above
        # signals sending the new title to the attached functions or
        # lambdas as the first parameter.
        self.setWindowTitle("This will trigger all the signals.")

    # SLOT: This accepts a string, e.g. the window title, to print
    def on_window_title_changed(self, s):
        print(s)

    # SLOT: This has default parameters so values are optional
    def my_custom_fn(self, a="HELLLO!", b=5):
        print(a, b)


app = QApplication(sys.argv)

window = MainWindow()
window.show()
app.exec()
